/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing;

import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.FlowValue;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.ArrayCreationInfo;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.flow.postprocessing.FlowPostProcessor;
import club.sk1er.mods.scrollabletooltips.mixinextras.expression.impl.utils.ExpressionASMUtils;
import club.sk1er.mods.scrollabletooltips.mixinextras.lib.apache.commons.tuple.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class NewArrayPostProcessor
implements FlowPostProcessor {
    private final Comparator<Pair<FlowValue, Integer>> insnIndexComparator = Comparator.comparingInt(o -> method.instructions.indexOf(((FlowValue)o.getLeft()).getInsn()));

    public NewArrayPostProcessor(MethodNode method) {
    }

    @Override
    public void process(FlowValue node2, FlowPostProcessor.OutputSink sink) {
        AbstractInsnNode insn = node2.getInsn();
        if (insn.getOpcode() == 189 || insn.getOpcode() == 188) {
            List<FlowValue> stores = this.getCreationStores(node2);
            if (stores == null || stores.isEmpty()) {
                return;
            }
            sink.markAsSynthetic(node2.getInput(0));
            for (FlowValue store : stores) {
                sink.markAsSynthetic(store);
                sink.markAsSynthetic(store.getInput(1));
            }
            node2.decorate("mixinextras_persistent_arrayCreationInfo", new ArrayCreationInfo(stores.get(stores.size() - 1)));
            node2.setParents((FlowValue[])stores.stream().map(it -> it.getInput(2)).toArray(FlowValue[]::new));
        }
    }

    private List<FlowValue> getCreationStores(FlowValue array) {
        Integer size = this.getIntConstant(array.getInput(0));
        if (size == null) {
            return null;
        }
        List sortedNext = array.getNext().stream().filter(it -> !((FlowValue)it.getLeft()).isComplex()).sorted(this.insnIndexComparator).map(Pair::getLeft).collect(Collectors.toList());
        if (sortedNext.size() < size) {
            return null;
        }
        ArrayList<FlowValue> stores = new ArrayList<FlowValue>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            FlowValue store = (FlowValue)sortedNext.get(i2);
            if (!this.isStore(array, store, i2)) {
                return null;
            }
            stores.add(store);
        }
        return stores;
    }

    private Integer getIntConstant(FlowValue node2) {
        if (node2.isComplex()) {
            return null;
        }
        Object cst = ExpressionASMUtils.getConstant(node2.getInsn());
        if (!(cst instanceof Integer)) {
            return null;
        }
        return (int)((Integer)cst);
    }

    private boolean isStore(FlowValue array, FlowValue store, int index) {
        int opcode = store.getInsn().getOpcode();
        if (opcode < 79 || opcode > 86) {
            return false;
        }
        if (store.getInput(0) != array) {
            return false;
        }
        return Objects.equals(index, this.getIntConstant(store.getInput(1)));
    }
}

